package ru.yandex.market.monitoring;

public class PersistedMonitoringUnit extends MonitoringUnit {
    private final MonitoringMetaDao monitoringMetaDao;

    public PersistedMonitoringUnit(String name, MonitoringMetaDao monitoringMetaDao) {
        super(name);
        this.monitoringMetaDao = monitoringMetaDao;
        monitoringMetaDao.saveMonitoringUnitMeta(name, super.getLastUpdateMillis());
    }

    @Override
    protected void setLastUpdateMillis(long lastUpdateMillis) {
        super.setLastUpdateMillis(lastUpdateMillis);
        monitoringMetaDao.saveMonitoringUnitMeta(name, lastUpdateMillis);
    }

    @Override
    public long getLastUpdateMillis() {
        final MonitoringMetaDao.MonitoringUnitMeta monitoringUnitMeta = monitoringMetaDao.getMonitoringUnitMeta(name);
        if (monitoringUnitMeta != null) {
            super.setLastUpdateMillis(monitoringUnitMeta.getLastUpdateTimeMillis());
        }
        return super.getLastUpdateMillis();
    }
}
