package ru.yandex.market.rotation;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Aleksei Malygin <a href="mailto:Malygin-Me@yandex-team.ru"></a>
 * Date: 2019-03-18
 */
public class DataRotationTask {

    private final Collection<ObsoletePartition> obsoletePartitions;
    private final int rotationPeriodDays;
    private final String pivotPartition;

    public DataRotationTask(Collection<ObsoletePartition> obsoletePartitions, int rotationPeriodDays,
                            String pivotPartition) {
        this.obsoletePartitions = Collections.unmodifiableCollection(obsoletePartitions);
        this.rotationPeriodDays = rotationPeriodDays;
        this.pivotPartition = pivotPartition;
    }

    public Collection<ObsoletePartition> getObsoletePartitions() {
        return obsoletePartitions;
    }

    public int getRotationPeriodDays() {
        return rotationPeriodDays;
    }

    public Set<String> getDistinctObsoletePartitions() {
        return obsoletePartitions.stream()
            .map(ObsoletePartition::getPartition)
            .collect(Collectors.toSet());
    }

    /**
     * @return a last clickhouse partition which shouldn't be rotated,
     * but all clickhouse partitions less than this partition should be rotated
     */
    public String getPivotPartition() {
        return pivotPartition;
    }
}
