package ru.yandex.market.rotation;

import ru.yandex.market.clickhouse.ddl.TableName;

import java.util.Objects;

/**
 * @author Aleksei Malygin <a href="mailto:Malygin-Me@yandex-team.ru"></a>
 * Date: 2019-03-11
 */
public class ObsoletePartition {
    private final String host;
    private final TableName tableName;
    private final String partition;
    private final String dropQuery;

    public ObsoletePartition(String host, TableName tableName, String partition) {
        this.host = host;
        this.tableName = new TableName(tableName.getFullName());
        this.partition = partition;
        this.dropQuery = "ALTER TABLE " + tableName.getFullName() + " DROP PARTITION " +
            ClickhousePartitionType.prepareQuotes(partition);
    }

    public String getHost() {
        return host;
    }

    public TableName getTableName() {
        return new TableName(tableName.getFullName());
    }

    public String getPartition() {
        return partition;
    }

    public String getDropQuery() {
        return dropQuery;
    }

    @Override
    public String toString() {
        return "ObsoletePartition{" +
            "host='" + host + '\'' +
            ", tableName=" + tableName +
            ", partition='" + partition + '\'' +
            ", dropQuery='" + dropQuery + '\'' +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ObsoletePartition that = (ObsoletePartition) o;
        return Objects.equals(host, that.host) &&
            Objects.equals(tableName, that.tableName) &&
            Objects.equals(partition, that.partition) &&
            Objects.equals(dropQuery, that.dropQuery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(host, tableName, partition, dropQuery);
    }
}
