package ru.yandex.market.statface;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 25/02/16
 */
public class StatfaceData {
    private final String reportName;
    private final StatfacePeriod period;

    private final List<StatfaceRow> rows = new ArrayList<>();

    public StatfaceData(StatfaceReportConfiguration reportConfiguration) {
        this(reportConfiguration.getName(), reportConfiguration.getPeriod());
    }

    public StatfaceData(String reportName, StatfacePeriod period) {
        this.reportName = reportName;
        this.period = period;
    }

    public void addRow(StatfaceRow row) {
        rows.add(row);
    }

    private JsonObject getDataObject() {
        JsonObject dataObject = new JsonObject();
        JsonArray valuesArray = new JsonArray();
        for (StatfaceRow row : rows) {
            valuesArray.add(row.getRowObject());
        }
        dataObject.add("values", valuesArray);
        return dataObject;
    }

    public String toJson() {
        return getDataObject().toString();
    }

    public StatfacePeriod getPeriod() {
        return period;
    }

    public String getReportName() {
        return reportName;
    }

    public int getRowCount() {
        return rows.size();
    }

    public boolean isEmpty() {
        return rows.isEmpty();
    }

}
