package ru.yandex.market.statface;

import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 18/02/16
 */
public class StatfaceGraph {
    private final String title;
    private final List<String> fields;
    private final GraphType type;

    public StatfaceGraph(String title, List<String> fields, GraphType type) {
        this.title = title;
        this.fields = fields;
        this.type = type;
    }

    // https://doc.yandex-team.ru/stat/report-overview/concepts/visualization/graphs-params.html#graphs-params__type
    public enum GraphType {
        line,
        bar,
        column,
        stack,
        stacked_100p,
        area,
        pie
    }

    public String getTitle() {
        return title;
    }

    public List<String> getFields() {
        return fields;
    }

    public GraphType getType() {
        return type;
    }
}
