package ru.yandex.market.statface;

import com.google.gson.JsonObject;
import ru.yandex.common.util.date.DateUtil;

import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 25/02/16
 */
public class StatfaceRow {

    public static final DateUtil.ThreadLocalDateFormat DATE_FORMAT = new DateUtil.ThreadLocalDateFormat(
        "yyyy-MM-dd HH:mm:ss"
    );

    private final JsonObject rowObject = new JsonObject();

    public StatfaceRow(Date date) {
        rowObject.addProperty(StatfaceField.DATE_FIELD.getName(), DATE_FORMAT.format(date));
    }

    public void addDimension(String name, String value) {
        rowObject.addProperty(name, value);
    }

    public void addValue(String name, double value) {
        rowObject.addProperty(name, value);
    }

    public void addValue(String name, String value) {
        rowObject.addProperty(name, value);
    }

    protected JsonObject getRowObject() {
        return rowObject;
    }
}
