package ru.yandex.market.statface.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author kukabara
 */
public class StatfaceComment {
    private static final List<String> DEFAULT_FIELDS = Collections.singletonList("value");

    long id;
    Date date;
    String path;
    String subject;
    List<String> tags;
    /**
     * список полей, к которым будет приписан комментарий
     */
    List<String> fields = DEFAULT_FIELDS;
    String user;
    /**
     * произвольные дополнительные данные
     * "position":"3"
     * "visible":1
     * "point_color":"#FFD800"
     */
    String metaData;

    public StatfaceComment() {
    }

    public StatfaceComment(String path, Date date, String subject, String pointColor) {
        this.path = path;
        this.date = date;
        this.subject = subject;
        buildMetaData(3, 0, pointColor);
    }

    public StatfaceComment(String path, Date date, String subject) {
        this(path, date, subject, null);
    }

    public long getId() {
        return id;
    }

    public String getUser() {
        return user;
    }

    public Date getDate() {
        return date;
    }

    public String getSubject() {
        return subject;
    }

    public String getPath() {
        return path;
    }

    public List<String> getTags() {
        return tags;
    }

    public List<String> getFields() {
        return fields;
    }

    public void buildMetaData(int position, int visible, String pointColor) {
        metaData = String.format("{\"position\":\"%s\",\"visible\":%s,\"point_color\":\"%s\"}",
            position, visible, pointColor);
    }

    public String getMetaData() {
        return metaData;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<>();
        }
        this.tags.add(tag);
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String toString() {
        return "StatfaceComment{" +
            "id=" + id +
            ", path='" + path + '\'' +
            ", date=" + date +
            ", subject='" + subject + '\'' +
            ", user='" + user + '\'' +
            ", fields=" + fields +
            ", tags=" + tags +
            ", metaData='" + metaData + '\'' +
            '}';
    }

}
