package ru.yandex.market.logshatter;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.market.monitoring.ComplicatedMonitoring;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 04.09.2018
 */
public class LogShatterMonitoring {
    private ComplicatedMonitoring hostCritical = new ComplicatedMonitoring();  // Значения по умолчанию для тестов
    private ComplicatedMonitoring clusterCritical = new ComplicatedMonitoring();

    /**
     * @return Все мониторинги.
     */
    public ComplicatedMonitoring.Result getOverallResult() {
        return ComplicatedMonitoring.combine(hostCritical, clusterCritical);
    }

    /**
     * Мониторинги, которые должны гореть критом даже если крит только на одном хосте.
     */
    public ComplicatedMonitoring getHostCritical() {
        return hostCritical;
    }

    @Required
    public void setHostCritical(ComplicatedMonitoring hostCritical) {
        this.hostCritical = hostCritical;
    }

    /**
     * Мониторинги, которые должны гореть критом только если крит на слишком большом количестве хостов.
     * @return
     */
    public ComplicatedMonitoring getClusterCritical() {
        return clusterCritical;
    }

    @Required
    public void setClusterCritical(ComplicatedMonitoring clusterCritical) {
        this.clusterCritical = clusterCritical;
    }
}
