package ru.yandex.market.logshatter;

import com.google.common.collect.Range;

import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 05/08/15
 */
public class LogShatterUtil {

    private static final long BYTES_IN_MEGABYTE = 1048576L;

    private LogShatterUtil() {
    }

    public static int bytesToMb(long bytes) {
        return (int) (bytes / BYTES_IN_MEGABYTE);
    }

    public static long mbToBytes(long mb) {
        return mb * BYTES_IN_MEGABYTE;
    }

    public static long calcSizeBytes(List<String> lines) {
        long sizeBytes = 0;
        for (String line : lines) {
            sizeBytes += line.length() * 2;
        }
        return sizeBytes;
    }

    public static PathMatcher createGlobMatcher(String globPattern) {
        globPattern = "glob:" + globPattern;
        globPattern = globPattern.replace("//", "/");
        return FileSystems.getDefault().getPathMatcher(globPattern);
    }

    public static Range<Integer> createRange(int timeSeconds, int roundSeconds) {
        int startTimeSeconds = timeSeconds - (timeSeconds % roundSeconds);
        return Range.closed(startTimeSeconds, startTimeSeconds + roundSeconds);
    }


}
