package ru.yandex.market.logshatter.abo;

import java.util.Optional;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.common.CommonRestLogParser;

/**
 * @author antipov93.
 */
public class CheckoutRefereeAccessLogParser extends CommonRestLogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("url", ColumnType.String),
        new Column("http_method", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("resptime_ms", ColumnType.Int32),
        new Column("method", ColumnType.String),
        new Column("uid", ColumnType.UInt64),
        new Column("dynamic", ColumnType.UInt8),
        new Column("shop_id", ColumnType.UInt64),
        new Column("from_service", ColumnType.String),
        new Column("is_manager", ColumnType.UInt8)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    @SuppressWarnings("checkstyle:magicnumber")
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        if (splits.length < 9) {
            return;
        }
        int timestampSeconds = Integer.parseInt(splits[1]);
        String httpMethod = splits[3];
        String url = splits[4];
        int statusCode = Integer.parseInt(splits[5]);
        int executionTimeMillis = Integer.parseInt(splits[6]);
        long uid = Long.parseLong(splits[7]);
        boolean isDynamic = splits[8].equals("1");

        long shopId = getStringValue(splits[9]).map(Long::parseLong).orElse(0L);
        String fromService = getStringValue(splits[10]).orElse("");
        boolean isManager = getStringValue(splits[11]).map(Boolean::parseBoolean).orElse(false);

        context.write(
            timestampSeconds, context.getHost(), url, httpMethod, statusCode, executionTimeMillis,
            clean(url), uid, isDynamic, shopId, fromService, isManager
        );
    }

    private static Optional<String> getStringValue(String value) {
        return Optional.ofNullable(value).filter(s -> !s.equals("null"));
    }
}
