package ru.yandex.market.logshatter.config;

import com.google.common.base.Splitter;

import java.util.List;
import java.util.Objects;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 05/08/15
 */
public class LogSource {
    public static final String SCHEMA_DELIMITER = "://";
    private final String uri;
    private final String schema;
    private final String path;

    private LogSource(String uri, String schema, String path) {
        this.uri = uri;
        this.schema = schema;
        this.path = path;
    }

    public static LogSource create(String origin) throws ConfigValidationException {
        List<String> splits = Splitter.on(SCHEMA_DELIMITER).limit(2).splitToList(origin);
        if (splits.size() != 2) {
            throw new ConfigValidationException("Wrong log sources: " + origin);
        }
        return new LogSource(origin, splits.get(0).toLowerCase(), splits.get(1));
    }

    public String getUri() {
        return uri;
    }

    public String getSchema() {
        return schema;
    }

    public String getPath() {
        return path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogSource logSource = (LogSource) o;
        return Objects.equals(uri, logSource.uri);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uri);
    }
}
