package ru.yandex.market.logshatter.config;

import ru.yandex.common.util.collections.MultiMap;
import ru.yandex.market.logshatter.parser.TableDescription;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Tatiana Litvinenko <a href="mailto:tanlit@yandex-team.ru"></a>
 * @date 03.06.2015
 */
public class ParserConfig {
    private static final String DEFAULT_DATA_FORMAT = "dd/MMM/yyyy:HH:mm:ss Z";
    private static final String DEFAULT_SEPARATOR = "\t";

    private String dateFormat = DEFAULT_DATA_FORMAT;
    private TimestampFormat timestampFormat = TimestampFormat.UNIXTIME;
    private String separator = DEFAULT_SEPARATOR;
    private List<String> fields;
    private List<String> dateFields;
    private Map<String, String> patterns;
    private boolean ignoreNoMatches;
    private Map<String, String> aliases;
    private Map<String, String> tskvMatch;
    private List<Condition> conditions;
    private MultiMap<String, String> requirement;
    private TableDescription tableDescription;
    private boolean useDefaultOnEmpty = false;
    private Map<String, String> dateFormats = Collections.emptyMap();

    public String getSeparator() {
        return separator;
    }

    public List<String> getFields() {
        return fields;
    }

    public List<String> getDateFields() {
        return dateFields == null ? Collections.emptyList() : dateFields;
    }

    public Map<String, String> getPatterns() {
        return patterns;
    }

    public MultiMap<String, String> getRequiredMap() {
        return requirement;
    }

    public boolean hasColumns() {
        return fields != null && !fields.isEmpty();
    }

    public boolean hasTskvMatch() {
        return tskvMatch != null;
    }

    public Map<String, String> getTskvMatch() {
        return tskvMatch;
    }

    public boolean hasPatterns() {
        return patterns != null && !patterns.isEmpty();
    }

    public boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public List<Condition> getConditions() {
        return conditions;
    }

    public boolean hasRequirement() {
        return requirement != null && !requirement.isEmpty();
    }

    public String getDateFormat() {
        return dateFormat;
    }

    public TimestampFormat getTimestampFormat() {
        return timestampFormat;
    }

    public boolean hasAliases() {
        return aliases != null && !aliases.isEmpty();
    }

    public Map<String, String> getAliases() {
        return aliases;
    }

    public TableDescription getTableDescription() {
        return tableDescription;
    }

    public void setTableDescription(TableDescription tableDescription) {
        this.tableDescription = tableDescription;
    }

    public boolean isIgnoreNoMatches() {
        return ignoreNoMatches;
    }

    public boolean isUseDefaultOnEmpty() {
        return useDefaultOnEmpty;
    }

    public Map<String, String> getDateFormats() {
        return dateFormats;
    }

    public class Condition {
        private String condition;
        private Map<String, String> thenValues;
        private Map<String, String> elseValues;

        public String getCondition() {
            return condition;
        }

        public Map<String, String> getThenValuesMap() {
            return thenValues == null ? Collections.<String, String>emptyMap() : thenValues;
        }

        public Map<String, String> getElseValuesMap() {
            return elseValues == null ? Collections.<String, String>emptyMap() : elseValues;
        }
    }
}
