package ru.yandex.market.logshatter.config.ddl;

import ru.yandex.market.logshatter.config.ddl.shard.UpdateShardDDLResult;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 23.01.17
 */
public class ShardResultsView {
    private final Map<Class<? extends UpdateShardDDLResult>, List<UpdateShardDDLResult>> resultMap;

    public ShardResultsView(List<UpdateShardDDLResult> allResults) {
        resultMap = allResults
            .stream()
            .collect(Collectors.groupingBy(UpdateShardDDLResult::getClass, Collectors.toList()));
    }

    public List<UpdateShardDDLResult.Success> getSuccessfulResults() {
        return getResultsOfType(UpdateShardDDLResult.Success.class);
    }

    public List<UpdateShardDDLResult.ManualDDLRequired> getManualDDLResults() {
        return getResultsOfType(UpdateShardDDLResult.ManualDDLRequired.class);
    }

    public List<UpdateShardDDLResult.Failure> getFailedResults() {
        return getResultsOfType(UpdateShardDDLResult.Failure.class);
    }

    public List<UpdateShardDDLResult.PartialSuccess> getPartialSuccessResults() {
        return getResultsOfType(UpdateShardDDLResult.PartialSuccess.class);
    }

    public List<? extends UpdateShardDDLResult> getUnsuccessfulResults() {
        return resultMap.entrySet()
            .stream()
            .filter(e -> e.getKey() != UpdateShardDDLResult.Success.class)
            .flatMap(e -> e.getValue().stream())
            .collect(Collectors.toList());
    }

    private <T> List<T> getResultsOfType(Class<T> clazz) {
        return resultMap.getOrDefault(clazz, Collections.emptyList())
            .stream()
            .map(clazz::cast)
            .collect(Collectors.toList());
    }
}
