package ru.yandex.market.logshatter.config.ddl;

import ru.yandex.market.clickhouse.ddl.DDL;
import ru.yandex.market.clickhouse.ddl.DdlQueryType;

import java.util.List;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 01.11.16
 */
public abstract class UpdateDDLTaskExecutorResult {
    public abstract UpdateDDLStatus asStatus();

    public static class Success extends UpdateDDLTaskExecutorResult {
        @Override
        public UpdateDDLStatus asStatus() {
            return UpdateDDLStatus.SUCCESS;
        }

        @Override
        public int hashCode() {
            return Success.class.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }

            if (obj == null || getClass() != obj.getClass()) {
                return false;
            }

            return true;
        }
    }

    public static class PartialSuccess extends UpdateDDLTaskExecutorResult {
        @Override
        public UpdateDDLStatus asStatus() {
            return UpdateDDLStatus.PARTIAL_SUCCESS;
        }

        @Override
        public int hashCode() {
            return PartialSuccess.class.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }

            if (obj == null || getClass() != obj.getClass()) {
                return false;
            }

            return true;
        }
    }

    public static class ManualDDLRequired extends UpdateDDLTaskExecutorResult {
        private final List<DDL> manualDDLs;

        public ManualDDLRequired(List<DDL> manualDDLs) {
            this.manualDDLs = manualDDLs;
        }

        public List<DDL> getManualDDLs() {
            return manualDDLs;
        }

        @Override
        public UpdateDDLStatus asStatus() {
            return isColumnDropsOnly() ? UpdateDDLStatus.COLUMN_DROPS_REQUIRED : UpdateDDLStatus.MANUAL_DDL_REQUIRED;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }

            if (o == null || getClass() != o.getClass()) {
                return false;
            }

            ManualDDLRequired that = (ManualDDLRequired) o;

            if ((manualDDLs == null && that.manualDDLs != null) || (manualDDLs != null && that.manualDDLs == null)) {
                return false;
            }

            if (manualDDLs != null &&
                (manualDDLs.size() != that.manualDDLs.size() || !manualDDLs.containsAll(that.manualDDLs))) {
                return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            return manualDDLs != null ? manualDDLs.hashCode() : 0;
        }

        private boolean isColumnDropsOnly() {
            return manualDDLs.stream()
                .flatMap(ddl -> ddl.getManualUpdates().stream())
                .allMatch(query -> query.getType().equals(DdlQueryType.DROP_COLUMN));
        }
    }
}
