package ru.yandex.market.logshatter.config.ddl.shard;

import ru.yandex.market.clickhouse.ddl.DDL;
import ru.yandex.market.logshatter.config.ddl.UpdateDDLException;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 31.10.16
 */
public abstract class UpdateHostDDLResult {
    public static class Success extends UpdateHostDDLResult {
        private final DDL ddl;

        public Success(DDL ddl) {
            this.ddl = ddl;
        }

        public DDL getDdl() {
            return ddl;
        }
    }

    public static class Error extends UpdateHostDDLResult {
        private final UpdateDDLException exception;

        Error(UpdateDDLException exception) {
            this.exception = exception;
        }

        public UpdateDDLException getException() {
            return exception;
        }
    }

    public static class ManualDDLRequired extends UpdateHostDDLResult {
        private final DDL manualDDL;

        ManualDDLRequired(DDL manualDDL) {
            this.manualDDL = manualDDL;
        }

        public DDL getManualDDL() {
            return manualDDL;
        }
    }
}
