package ru.yandex.market.logshatter.config.ddl.shard;

import ru.yandex.market.clickhouse.ClickhouseTemplate;
import ru.yandex.market.clickhouse.ddl.ClickHouseDdlServiceOld;
import ru.yandex.market.clickhouse.ddl.ClickHouseTableDefinition;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 27.01.17
 */
public class UpdateHostDDLTaskFactory {
    private final ClickHouseDdlServiceOld clickhouseDdlService;

    private final ClickhouseTemplate clickhouseTemplate;

    public UpdateHostDDLTaskFactory(ClickHouseDdlServiceOld clickhouseDdlService, ClickhouseTemplate clickhouseTemplate) {
        this.clickhouseDdlService = clickhouseDdlService;
        this.clickhouseTemplate = clickhouseTemplate;
    }

    public UpdateHostDDLTask create(String host, ClickHouseTableDefinition tableDefinition) {
        return new UpdateHostDDLTaskImpl(host, tableDefinition, clickhouseDdlService, clickhouseTemplate);
    }
}
