package ru.yandex.market.logshatter.config.ddl.shard;

import ru.yandex.market.clickhouse.ddl.DDL;
import ru.yandex.market.logshatter.config.ddl.UpdateDDLException;

import java.util.List;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 23.01.17
 */
public abstract class UpdateShardDDLResult {
    private final UpdateShardDDLTask task;

    UpdateShardDDLResult(UpdateShardDDLTask task) {
        this.task = task;
    }

    public static class Success extends UpdateShardDDLResult {
        private final List<DDL> ddls;

        public Success(UpdateShardDDLTask task, List<DDL> ddls) {
            super(task);
            this.ddls = ddls;
        }

        public List<DDL> getDdls() {
            return ddls;
        }
    }

    public static class PartialSuccess extends UpdateShardDDLResult {
        private final List<UpdateDDLException> exceptions;

        public PartialSuccess(UpdateShardDDLTask task, List<UpdateDDLException> exceptions) {
            super(task);
            this.exceptions = exceptions;
        }

        public List<UpdateDDLException> getExceptions() {
            return exceptions;
        }
    }

    public static class Failure extends UpdateShardDDLResult {
        private final List<UpdateDDLException> exceptions;

        public Failure(UpdateShardDDLTask task, List<UpdateDDLException> exceptions) {
            super(task);
            this.exceptions = exceptions;
        }

        public List<UpdateDDLException> getExceptions() {
            return exceptions;
        }
    }

    public static class ManualDDLRequired extends UpdateShardDDLResult {
        private final List<DDL> manualDDLs;

        public ManualDDLRequired(UpdateShardDDLTask task, List<DDL> manualDDLs) {
            super(task);
            this.manualDDLs = manualDDLs;
        }

        public List<DDL> getManualDDLs() {
            return manualDDLs;
        }
    }

    public UpdateShardDDLTask getTask() {
        return task;
    }
}
