package ru.yandex.market.logshatter.logging;

import ru.yandex.market.logshatter.reader.SourceContext;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 12.10.16
 */
public class BatchErrorLoggerFactory {
    private final int errorsCountToBeginGrouping;
    private final int errorsCountToBeginReducedGrouping;

    public BatchErrorLoggerFactory(int errorsCountToBeginGrouping, int errorsCountToBeginReducedGrouping) {
        this.errorsCountToBeginGrouping = errorsCountToBeginGrouping;
        this.errorsCountToBeginReducedGrouping = errorsCountToBeginReducedGrouping;
    }

    public BatchErrorLogger createErrorLogger(SourceContext sourceContext) {
        return new BatchErrorLogger(
            new ErrorLogger(sourceContext),
            errorsCountToBeginGrouping,
            errorsCountToBeginReducedGrouping
        );
    }
}
