package ru.yandex.market.logshatter.logging;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.market.logshatter.reader.SourceContext;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 12.10.16
 */
public class ErrorLogger {
    private static final Logger parserLog = LogManager.getLogger("parser");
    private final SourceContext sourceContext;

    public ErrorLogger(SourceContext sourceContext) {
        this.sourceContext = sourceContext;
    }

    public void logErrorGroupWithoutStacktrace(ErrorSample errorSample, int count) {
        logErrorGroup(errorSample, count, false);
    }

    public void logErrorGroup(ErrorSample errorSample, int count) {
        logErrorGroup(errorSample, count, true);
    }

    public void logErrorGroup(ErrorSample errorSample, int count, boolean withStacktrace) {
        String message = String.format(
            "%d exception%s of type %s, %s failed to parse file %s from host %s, sample line: %s",
            count,
            count == 1 ? "" : "s",
            errorSample.getException().getClass().getName(),
            sourceContext.getLogParser().getClass().getName(),
            sourceContext.getPath(),
            sourceContext.getHost(),
            errorSample.getLine()
        );

        if (withStacktrace) {
            parserLog.error(message, errorSample.getException());
        } else {
            parserLog.error(message);
        }
    }

    public void logSingleError(ErrorSample error) {
        parserLog.error(
            String.format(
                "Failed to parse file %s from host %s, line: %s",
                sourceContext.getPath(),
                sourceContext.getHost(),
                error.getLine()
            ),
            error.getException()
        );
    }
}
