package ru.yandex.market.logshatter.logging;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 12.10.16
 */
public class ErrorSample {
    private final Exception exception;
    private final String line;

    public ErrorSample(Exception exception, String line) {
        this.exception = exception;
        this.line = line;
    }

    public Exception getException() {
        return exception;
    }

    public String getLine() {
        return line;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ErrorSample that = (ErrorSample) o;

        return exception != null ? exception.getClass().equals(that.exception.getClass()) : that.exception == null;
    }

    @Override
    public int hashCode() {
        return exception != null ? exception.getClass().hashCode() : 0;
    }
}
