package ru.yandex.market.logshatter.meta;

import java.util.Objects;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 29/04/15
 */
public class SourceKey {
    private final String origin;
    private final String id;
    private final String table;

    public SourceKey(String origin, String id, String table) {
        this.origin = origin;
        this.id = id;
        this.table = table;
    }

    public String getId() {
        return id;
    }

    public String getTable() {
        return table;
    }

    public String getOrigin() {
        return origin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SourceKey sourceKey = (SourceKey) o;
        return Objects.equals(origin, sourceKey.origin) &&
            Objects.equals(id, sourceKey.id) &&
            Objects.equals(table, sourceKey.table);
    }

    @Override
    public int hashCode() {
        return Objects.hash(origin, id, table);
    }

    @Override
    public String toString() {
        return "SourceKey{" +
            "origin='" + origin + '\'' +
            ", id='" + id + '\'' +
            ", table='" + table + '\'' +
            '}';
    }
}
