package ru.yandex.market.logshatter.meta;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 29/04/15
 */
public class SourceMeta {
    private final SourceKey key;
    private volatile String name;
    private volatile long dataOffset;
    private volatile long fileOffset;

    public SourceMeta(SourceKey key) {
        this.key = key;
    }

    public SourceMeta(SourceKey key, String name, long dataOffset, long fileOffset) {
        this.key = key;
        this.name = name;
        this.dataOffset = dataOffset;
        this.fileOffset = fileOffset;
    }

    public String getId() {
        return key.getId();
    }

    public String getTable() {
        return key.getTable();
    }

    public SourceKey getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public long getDataOffset() {
        return dataOffset;
    }

    protected void setDataOffset(long dataOffset) {
        this.dataOffset = dataOffset;
    }

    public long getFileOffset() {
        return fileOffset;
    }

    protected void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }
}
