package ru.yandex.market.logshatter.output;

import ru.yandex.market.health.ProcessingQueue;
import ru.yandex.market.logshatter.config.LogShatterConfig;
import ru.yandex.market.logshatter.reader.SourceContext;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 17/02/15
 */
public class ConfigOutputQueue extends ProcessingQueue<SourceContext> {

    private final LogShatterConfig logShatterConfig;

    public ConfigOutputQueue(LogShatterConfig logShatterConfig) {
        this.logShatterConfig = logShatterConfig;
    }

    public LogShatterConfig getLogShatterConfig() {
        return logShatterConfig;
    }

    @Override
    protected boolean isUpdated(SourceContext fileContext) {
        return !fileContext.getOutputQueue().isEmpty();
    }
}

