package ru.yandex.market.logshatter.parser;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 23/02/15
 * @deprecated use tskv logs
 */
@Deprecated
public class ComplicatedLineParser {
    private String string;
    private int position;

    public void setLine(String string) {
        this.string = string;
        position = 0;
    }

    public void setLine(String string, int startPosition) {
        this.string = string;
        position = startPosition;
    }

    public String getStringSurroundedBy(char c, boolean quoteChar) {
        return getStringSurroundedBy(c, c, quoteChar);
    }

    public String getStringSurroundedBySpace() {
        return getStringSurroundedBy(' ', ' ', false);
    }

    public String getStringSurroundedByQuote() {
        return getStringSurroundedBy('"', '"', true);
    }

    public String getStringSurroundedBy(char startChar, char endChar, boolean quoteChar) {
        int indexOfStart = string.indexOf(startChar, position);
        if (indexOfStart == -1) {
            throw new IllegalStateException("No such part");
        }
        int start = indexOfStart + 1;
        int end = string.indexOf(endChar, start);
        if (end == -1) {
            end = string.length();
        }
        position = quoteChar ? end + 1 : end;
        return string.substring(start, end);
    }

    public void ignoreSurroundedBySpace() {
        ignoreSurroundedBy(' ', ' ', false);
    }

    public void ignoreSurroundedByQuote() {
        ignoreSurroundedBy('"', '"', true);
    }

    public void ignoreSurroundedBy(char startChar, char endChar, boolean quoteChar) {
        int start = string.indexOf(startChar, position) + 1;
        int end = string.indexOf(endChar, start);
        if (end == -1) {
            end = string.length();
        }
        position = quoteChar ? end + 1 : end;
//        position = end + 1;
    }
}
