package ru.yandex.market.logshatter.parser;

import com.google.common.base.Preconditions;
import ru.yandex.market.logshatter.parser.trace.Environment;

import java.util.HashMap;
import java.util.Map;

public class EnvironmentMapper {
    public static final String LOGBROKER_PROTOCOL_PREFIX = "logbroker://";

    private Map<String, Environment> originToEnvironmentMapping;
    private final String keyPrefix;

    public EnvironmentMapper(String keyPrefix) {
        Preconditions.checkArgument(keyPrefix != null);

        this.keyPrefix = keyPrefix;
    }

    /**
     * Get environment from parser context.
     *
     * @param context parser context
     * @return Environment
     */
    public Environment getEnvironment(ParserContext context) {
        if (originToEnvironmentMapping == null) {
            originToEnvironmentMapping = getOriginToEnvironmentMapping(keyPrefix, context.getParams());
        }

        return originToEnvironmentMapping.getOrDefault(context.getOrigin(), Environment.UNKNOWN);
    }

    private static Map<String, Environment> getOriginToEnvironmentMapping(String keyPrefix, Map<String, String> params) {
        Map<String, Environment> mapping = new HashMap<>();
        int keyPrefixLength = keyPrefix.length();

        if (params.isEmpty()) {
            return mapping;
        }

        for (Map.Entry<String, String> paramEntry : params.entrySet()) {
            String key = paramEntry.getKey();
            if (key.startsWith(keyPrefix)) {
                mapping.put(
                        key.substring(keyPrefixLength),
                        Environment.valueOf(paramEntry.getValue())
                );
            }
        }

        return mapping;
    }
}
