package ru.yandex.market.logshatter.parser;

import com.google.gson.Gson;
import com.google.gson.JsonObject;

import java.util.Map;
import java.util.stream.Collectors;

public class JsonLineParser extends KeyValueExtractor {

    private static final Gson gson = new Gson();

    private static Map<String, String> parseKeyValues(String json) {
        return gson.fromJson(json, JsonObject.class)
            .entrySet()
            .stream()
            .collect(Collectors.toMap(
                Map.Entry::getKey,
                e -> e.getValue().isJsonPrimitive() ? e.getValue().getAsString() : e.getValue().toString()
            ));
    }

    public JsonLineParser(String json) {
        super(parseKeyValues(json));
    }
}
