package ru.yandex.market.logshatter.parser;

import ru.yandex.market.logshatter.url.PageMatcher;
import ru.yandex.market.logshatter.useragent.UserAgentDetector;

import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 14/02/15
 */
public interface ParserContext {
    /**
     * Имя файла лога
     *
     * @return
     */
    Path getFile();

    /**
     * Имя хоста, с коротрого приехали логи
     *
     * @return
     */
    String getHost();

    /**
     * Номер инстанса (слота) в RTC
     *
     * @return
     */
    int getInstanceId();

    String getLogBrokerTopic();

    /**
     * Источник данных. Имя хоста парсера в случае локальной машины, ident с случае LogBroker
     *
     * @return
     */
    String getOrigin();

    PageMatcher getPageMatcher();

    UserAgentDetector getUserAgentDetector();

    default String getParam(String name){
        return null;
    }

    default Map<String, String> getParams(){
        return Collections.emptyMap();
    }

    void write(Date date, Object... fields);

    default void write(ZonedDateTime dateTime, Object... fields) {
        write(new Date(dateTime.toEpochSecond() * 1000L), fields);
    }

    default void write(OffsetDateTime dateTime, Object... fields) {
        write(new Date(dateTime.toEpochSecond() * 1000L), fields);
    }

    default void write(int timestampSeconds, Object... fields) {
        write(new Date(timestampSeconds * 1000L), fields);
    }
}
