package ru.yandex.market.logshatter.parser.bs;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 29/09/15
 */
public class YabsLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("reqid", ColumnType.String),
        new Column("resptime_ms", ColumnType.UInt32),
        new Column("status", ColumnType.UInt8)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        int timestampSeconds = (int) Double.parseDouble(splits[1]);

        for (String service : splits[7].split(" ")) {
            if (!service.startsWith("market")) {
                continue;
            }
            String serviceSplits[] = service.split(":");
            boolean status = serviceSplits[1].equals("+");
            int respTimeMillis = (int) (Double.parseDouble(serviceSplits[2]) * 1000);
            String reqId = ParseUtils.extractStringParam(splits[10], "reqid");
            context.write(timestampSeconds, context.getHost(), reqId, respTimeMillis, status);
            return;
        }
    }
}
