package ru.yandex.market.logshatter.parser.checkout;

import org.apache.commons.lang.math.NumberUtils;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

public class AntiFraudLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
            new Column("host", ColumnType.String),
            new Column("detector_name", ColumnType.String),
            new Column("order_id", ColumnType.UInt64),
            new Column("buyer", ColumnType.String),
            new Column("payment", ColumnType.String)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    /**
     * Описание полей
     * timestamp
     * detector_name
     * order_id
     * buyer
     * payment
     */
    @Override
    @SuppressWarnings("checkstyle:magicnumber")
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        if (splits.length < 2) {
            return;
        }
        int timestampSeconds = Integer.parseInt(splits[1]);
        String detectorName = splits[2];
        long orderId = splits.length >= 4 ? NumberUtils.toLong(splits[3]) : 0;
        String buyer = splits.length >= 5 ? splits[4] : "";
        String payment = splits.length >= 6 ? splits[5] : "";
        context.write(timestampSeconds, context.getHost(), detectorName, orderId, buyer, payment);
    }

}
