package ru.yandex.market.logshatter.parser.checkout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

public class CheckoutQueryProfilerParser implements LogParser {
    @Override
    public TableDescription getTableDescription() {
        return TableDescription.createDefault(
            new Column("client_ip", ColumnType.String),
            new Column("host", ColumnType.String),
            new Column("method", ColumnType.String),
            new Column("url", ColumnType.String),
            new Column("http_code", ColumnType.UInt16),
            new Column("resptime_ms", ColumnType.Int32),
            new Column("market_request_id", ColumnType.String),
            new Column("type", ColumnType.String),
            new Column("duration_ms", ColumnType.Int32)
        );
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        if(splits.length < 10) {
            return;
        }
        int timestampSeconds = Integer.parseInt(splits[1]);
        String clientIp = splits[2];
        String method = splits[3];
        String url = splits[4];
        int httpCode = Integer.parseInt(splits[5]);
        int resptimeMs = Integer.parseInt(splits[6]);
        String marketRequestId = splits[7];
        String type = splits[8];
        int durationMs = Integer.parseInt(splits[9]);

        context.write(timestampSeconds, clientIp, context.getHost(), method, clean(url), httpCode, resptimeMs, marketRequestId, type, durationMs);
    }

    private String clean(String url) {
        return url.replaceAll("/\\d+", "").replaceAll("/$", "").replaceAll("\\.json$", "");
    }
}
