package ru.yandex.market.logshatter.parser.checkout;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import ru.yandex.common.util.StringUtils;
import ru.yandex.market.logshatter.parser.ParserException;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class KeyValueParserUtil {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    private KeyValueParserUtil() {
        throw new UnsupportedOperationException("");
    }

    @Nonnull
    public static KeysAndValues parseKeysAndValues(@Nullable String kvJson) throws ParserException {
        if (StringUtils.isEmpty(kvJson)) {
            return new KeysAndValues(Collections.emptyList(), Collections.emptyList());
        }
        try {
            Map<String, Object> parsed = MAPPER.readValue(kvJson, new TypeReference<Map<String, Object>>() {});
            List<String> values = parsed.values().stream()
                .map(String::valueOf)
                .collect(Collectors.toList());
            return new KeysAndValues(parsed.keySet(), values);
        } catch (IOException e) {
            throw new ParserException("Failed to parse key value json", e);
        }
    }

    public static class KeysAndValues {
        private final Collection<String> keys;
        private final Collection<String> values;

        public KeysAndValues(Collection<String> keys, Collection<String> values) {
            this.keys = keys;
            this.values = values;
        }

        public Collection<String> getKeys() {
            return keys;
        }

        public Collection<String> getValues() {
            return values;
        }
    }
}
