package ru.yandex.market.logshatter.parser.checkout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * @author mmetlov
 */
public class NotifierIncomingKvLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("kv_keys", ColumnType.ArrayString),
        new Column("kv_values", ColumnType.ArrayString),
        new Column("host", ColumnType.String)
    );

    private static ThreadLocal<SimpleDateFormat> DATE_FORMAT_HOLDER =
        ThreadLocal.withInitial(() -> new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.ENGLISH));

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        Date date = DATE_FORMAT_HOLDER.get().parse(splits[0]);
        String kvJson = splits[1];
        KeyValueParserUtil.KeysAndValues keysAndValues = KeyValueParserUtil.parseKeysAndValues(kvJson);

        context.write(
            date,
            keysAndValues.getKeys(),
            keysAndValues.getValues(),
            context.getHost()
        );
    }
}
