package ru.yandex.market.logshatter.parser.checkout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class NotifierNotificationLogParser implements LogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
            new Column("host", ColumnType.String),
            new Column("id", ColumnType.UInt64),
            new Column("type", ColumnType.String),
            new Column("order_id", ColumnType.UInt64),
            new Column("request_id", ColumnType.String),
            new Column("delivery_channels", ColumnType.String),
            new Column("kv_keys", ColumnType.ArrayString),
            new Column("kv_values", ColumnType.ArrayString)
    );

    private static ThreadLocal<SimpleDateFormat> DATE_FORMAT_HOLDER =
        ThreadLocal.withInitial(() -> new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.ENGLISH));


    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    @SuppressWarnings("checkstyle:magicnumber")
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        if (splits.length < 2) {
            return;
        }

        Date date = DATE_FORMAT_HOLDER.get().parse(splits[0]);
        int id = Integer.parseInt(splits[1]);
        String type = splits.length > 2 ? splits[2] : "";
        int orderId = splits.length > 3 ? Integer.parseInt(splits[3]) : 0;
        String requestId = splits.length > 4 ? splits[4] : "";
        String deliveryChannels = splits.length > 5 ? splits[5] : "";
        String kvJson = splits.length > 6 ? splits[6] : null;

        KeyValueParserUtil.KeysAndValues keysAndValues = KeyValueParserUtil.parseKeysAndValues(kvJson);

        context.write(
            date,
            context.getHost(),
            id,
            type,
            orderId,
            requestId,
            deliveryChannels,
            keysAndValues.getKeys(),
            keysAndValues.getValues()
        );
    }

}
