package ru.yandex.market.logshatter.parser.checkout;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TskvSplitter;

import java.util.Date;

public class PushApiLogParser implements LogParser {
    @Override
    public TableDescription getTableDescription() {
        return TableDescription.createDefault(
                new Column("shopId", ColumnType.UInt64),
                new Column("user_id", ColumnType.UInt64),
                new Column("success", ColumnType.UInt8),
                new Column("sandbox", ColumnType.UInt8),
                new Column("request", ColumnType.String),
                new Column("url", ColumnType.String),
                new Column("args", ColumnType.String),
                new Column("responseTimeMs", ColumnType.UInt32),
                new Column("responseError", ColumnType.String),
                new Column("responseSubError", ColumnType.String),
                new Column("errorDescription", ColumnType.String),
                new Column("requestMethod", ColumnType.String),
                new Column("partnerInterface", ColumnType.UInt8),
                new Column("context", ColumnType.String),
                new Column("apiSettings", ColumnType.String),
                new Column("actionId", ColumnType.String),
                new Column("orderId", ColumnType.UInt64),
                new Column("requestId", ColumnType.String)
        );
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        TskvSplitter values = new TskvSplitter(line);
        context.write(
                new Date(values.getLong("eventtime")),
                values.getLong("shopId"),
                values.getLong("user_id"),
                values.getBoolean("success"),
                values.getBoolean("sandbox"),
                values.getString("request"),
                values.getString("url"),
                values.getOptionalString("args", ""),
                values.getInt("responseTime"),
                values.getOptionalString("responseError", ""),
                values.getOptionalString("responseSubError", ""),
                values.getOptionalString("errorDescription", ""),
                values.getString("requestMethod"),
                values.getBoolean("partnerInterface"),
                values.getString("context"),
                values.getString("apiSettings"),
                values.getOptionalString("actionId", ""),
                values.getOptionalLong("orderId", 0L),
                values.getString("requestId")
        );
    }
}
