package ru.yandex.market.logshatter.parser.checkout.difflogs;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.checkout.CheckoutJsonLogParser;

import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Nicolai Iusiumbeli <mailto:armor@yandex-team.ru>
 *         date: 23/03/2017
 */
public class CheckoutDiffLogParser extends CheckoutJsonLogParser {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("^\\[(.{23,23})\\] (.*)$");
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
            new Column("host", ColumnType.String),
            new Column("logType", ColumnType.String),
            new Column("eventType", ColumnType.String),
            new Column("context", ColumnType.String),
            new Column("buyerPrice", ColumnType.Float64),
            new Column("actualPrice", ColumnType.Float64),
            new Column("buyerCount", ColumnType.Int32),
            new Column("actualCount", ColumnType.Int32),
            new Column("global", ColumnType.UInt8),
            new Column("shopId", ColumnType.UInt64),
            new Column("rgb", ColumnType.String),
            new Column("warehouseId", ColumnType.Int32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        Matcher matcher = SPLIT_PATTERN.matcher(line);
        if (!matcher.find()) return;

        String time = matcher.group(1);
        String json = matcher.group(2);
        DiffLog diffLog = gson.fromJson(json, DiffLog.class);
        context.write(
                dateFormat.parse(time),
                context.getHost(),
                diffLog.getLogType(),
                diffLog.getEvent(),
                diffLog.getCart().getContext(),
                diffLog.getItem().getBuyerPrice(),
                diffLog.getAdditionalLoggingInfo().getActualBuyerPrice(),
                diffLog.getItem().getCount(),
                diffLog.getAdditionalLoggingInfo().getActualCartItemCount(),
                Boolean.TRUE.equals(diffLog.getCart().getGlobal()),
                diffLog.getCart().getShopId(),
                diffLog.getCart().getRgb(),
                diffLog.getItem().getWarehouseId()
        );
    }
}
