package ru.yandex.market.logshatter.parser.checkout.events;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author Nicolai Iusiumbeli <mailto:armor@yandex-team.ru>
 *         date: 10/03/2017
 */
public class Order {
    private Long id;
    private Long uid = -1L;
    private Long muid = -1L;
    private String status = "";
    private String substatus = "";
    private String paymentMethod = "";
    private Delivery delivery = new Delivery();
    private Buyer buyer = new Buyer();
    private Payment payment = new Payment();
    private String context;
    private Boolean global;
    private Long shopId;
    private String rgb = "";
    private Boolean fulfilment;
    @SerializedName("preorder")
    private Boolean preOrder;
    private List<OrderItem> items;
    private Properties properties;

    public Long getId() {
        return id;
    }

    public Long getUid() {
        return uid;
    }

    public Long getMuid() {
        return muid;
    }

    public String getPaymentMethod() {
        return paymentMethod;
    }

    public Delivery getDelivery() {
        return delivery;
    }

    public Buyer getBuyer() {
        return buyer;
    }

    public Payment getPayment() {
        return payment;
    }

    public String getStatus() {
        return status;
    }

    public String getSubstatus() {
        return substatus;
    }

    public String getContext() {
        return context;
    }

    public Boolean getGlobal() {
        return global;
    }

    public Long getShopId() {
        return shopId;
    }

    public String getRgb() {
        return rgb;
    }

    public Boolean getPreOrder() {
        return preOrder;
    }

    public Boolean getFulfilment() {
        return fulfilment;
    }

    public List<OrderItem> getItems() {
        return items;
    }

    public Properties getProperties() {
        return properties;
    }

    public Integer getWarehouseId() {
        return Optional.ofNullable(items)
            .filter(oi -> !oi.isEmpty())
            .map(oi -> oi.iterator().next().getWarehouseId())
            .orElse(1);
    }

    public List<Integer> getCargoTypes() {
        if (items == null) {
            return new ArrayList<>();
        }
        return items.stream()
            .filter(oi -> oi.getCargoTypes() != null)
            .flatMap(oi -> oi.getCargoTypes().stream())
            .distinct()
            .collect(Collectors.toList());
    }
}
