package ru.yandex.market.logshatter.parser.common;

import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

/**
 * Абстрактный парсер для логов в формате
 * https://wiki.yandex-team.ru/market/development/access
 *
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 24/02/15
 */
public abstract class CommonAssessLogParser implements LogParser {

    /**
     * Описание полей
     * Дата (в формате "dd/MMM/yyyy:HH:mm:ss Z")
     * Таймстемп в сек
     * client ip
     * http_method
     * geturl
     * http_status_code
     * execution_time_ms
     * user_id
     * dynamic (1/0)
     *
     * @param line
     * @param context
     * @throws Exception
     */
    @Override
    @SuppressWarnings("checkstyle:magicnumber")
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        if (splits.length < 9) {
            return;
        }
        int timestampSeconds = Integer.parseInt(splits[1]);
        String httpMethod = splits[3];
        String url = splits[4];
        int statusCode = Integer.parseInt(splits[5]);
        int executionTimeMillis = Integer.parseInt(splits[6]);
        long uid = Long.parseLong(splits[7]);
        boolean isDynamic = splits[8].equals("1");

        String marketRequestId;
        if (splits.length > 9) {
            marketRequestId = splits[9];
        } else {
            marketRequestId = "";
        }

        write(context, timestampSeconds, httpMethod, url, statusCode, executionTimeMillis, uid, isDynamic, marketRequestId);
    }

    // можно переопределить пустым методом, если переопределить метод с marketRequestId
    protected abstract void write(ParserContext context, int timestampSeconds, String httpMethod, String url,
                                  int statusCode, int executionTimeMillis, long uid, boolean isDynamic);

    protected void write(ParserContext context, int timestampSeconds, String httpMethod, String url,
                         int statusCode, int executionTimeMillis, long uid, boolean isDynamic, String marketRequestId) {
        // Реализация по умолчанию без смены формата
        write(context, timestampSeconds, httpMethod, url, statusCode, executionTimeMillis, uid, isDynamic);
    }
}
