package ru.yandex.market.logshatter.parser.common;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.ParserContext;

/**
 * Парсер для логов common-framework
 *
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 24/02/15
 */
public class CommonFrameworkLogParser extends CommonAssessLogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("method", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("resptime_ms", ColumnType.Int32),
        new Column("uid", ColumnType.UInt64)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    protected void write(ParserContext context, int timestampSeconds, String httpMethod, String url,
                         int statusCode, int executionTimeMillis, long uid, boolean isDynamic) {
        //По httpMethod нету информации, isDynamic всегда true
        context.write(timestampSeconds, context.getHost(), url, statusCode, executionTimeMillis, uid);
    }
}
