package ru.yandex.market.logshatter.parser.common;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.ParserContext;

/**
 * Парсер для логов common-gwt
 * Пример таблички в clickhouse:
 * CREATE TABLE market.MODULE_NAME (date Date, timestamp UInt32, host String, url String, http_method String,
 * http_code UInt16, resptime_ms Int32, uid UInt64, dynamic UInt8) ENGINE = MergeTree(date, (timestamp), 8192)
 *
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 24/02/15
 */
public class CommonGwtLogParser extends CommonAssessLogParser {

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("url", ColumnType.String),
        new Column("http_method", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("resptime_ms", ColumnType.Int32),
        new Column("uid", ColumnType.UInt64),
        new Column("dynamic", ColumnType.UInt8)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    protected void write(ParserContext context, int timestampSeconds, String httpMethod, String url,
                         int statusCode, int executionTimeMillis, long uid, boolean isDynamic) {
        context.write(
            timestampSeconds, context.getHost(), url, httpMethod, statusCode, executionTimeMillis, uid, isDynamic
        );
    }
}
