package ru.yandex.market.logshatter.parser.common;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.ParserContext;

/**
 * 'Выкусывает' из адреса:
 * параметры, которые меняются от ручки к ручке (числа, числа+буквы для UUID, числа через запятую для PATCH запросов)
 * также убирает из хвоста .json, .xml и последний /
 *
 * @author kukabara
 */
public class CommonRestLogParser extends CommonAssessLogParser {
    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("url", ColumnType.String),
        new Column("http_method", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("resptime_ms", ColumnType.Int32),
        new Column("method", ColumnType.String),
        new Column("uid", ColumnType.UInt64),
        new Column("dynamic", ColumnType.UInt8)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    protected void write(ParserContext context, int timestampSeconds, String httpMethod, String url,
                         int statusCode, int executionTimeMillis, long uid, boolean isDynamic) {
        context.write(
            timestampSeconds, context.getHost(), url, httpMethod, statusCode, executionTimeMillis,
            clean(url), uid, isDynamic
        );
    }

    protected String clean(String url) {
        String cleanUrl = url
            .replaceAll("/[a-f0-9]{32}", "/*") // UUID
            .replaceAll("/[\\d,]+", "/*")
            .replaceAll("/$", "")
            .replaceAll("\\.json$", "")
            .replaceAll("\\.xml$", "");
        return cleanUrl;
    }
}
