package ru.yandex.market.logshatter.parser.delivery;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.delivery.component.DeliveryApplicationLogEntry;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         02.03.16.
 */
public class DeliveryApplicationLogParser implements LogParser {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        //Main parsed data
        new Column("channels", ColumnType.ArrayString),
        new Column("level", ColumnType.String),
        new Column("text", ColumnType.String),

        //Context
        new Column("context_attributes", ColumnType.String),
        new Column("context_delivery_id", ColumnType.String),
        new Column("context_delivery_unique_name", ColumnType.String),
        new Column("context_email", ColumnType.String),
        new Column("context_exception", ColumnType.String),
        new Column("context_group", ColumnType.String),
        new Column("context_login", ColumnType.String),
        new Column("context_merge_vars", ColumnType.String),
        new Column("context_options", ColumnType.String),
        new Column("context_order_id", ColumnType.String),
        new Column("context_pickup_point_code", ColumnType.String),
        new Column("context_full", ColumnType.String),

        //External data
        new Column("external_data_application_id", ColumnType.String),
        new Column("external_data_execution_time", ColumnType.String),
        new Column("external_data_hostname", ColumnType.String),
        new Column("external_data_request", ColumnType.String),

        //External data request parsed data
        new Column("external_data_request_method_name", ColumnType.String),
        new Column("external_data_request_hash", ColumnType.String),
        new Column("external_data_request_token", ColumnType.String),
        new Column("external_data_request_sender_id_yandex", ColumnType.ArrayString),
        new Column("external_data_request_warehouse_id_yandex", ColumnType.ArrayString),
        new Column("external_data_request_warehouse_id_delivery", ColumnType.ArrayString),
        new Column("external_data_request_shipment_id_yandex", ColumnType.ArrayString),
        new Column("external_data_request_shipment_id_delivery", ColumnType.ArrayString),
        new Column("external_data_request_order_id_clean", ColumnType.ArrayString),
        new Column("external_data_request_order_id_yandex", ColumnType.ArrayString),
        new Column("external_data_request_order_id_delivery", ColumnType.ArrayString),
        new Column("external_data_request_order_id_external", ColumnType.ArrayString),
        new Column("external_data_request_intake_id_yandex", ColumnType.ArrayString),
        new Column("external_data_request_register_id_yandex", ColumnType.ArrayString),
        new Column("external_data_request_self_export_id_yandex", ColumnType.ArrayString),
        new Column("external_data_request_self_export_id_delivery", ColumnType.ArrayString),

        new Column("external_data_response", ColumnType.String),

        //External data response parsed data
        new Column("external_data_response_method_name", ColumnType.String),
        new Column("external_data_response_hash", ColumnType.String),
        new Column("external_data_response_is_error", ColumnType.Int8),
        new Column("external_data_response_intake_id_yandex", ColumnType.ArrayString),
        new Column("external_data_response_order_id_clean", ColumnType.ArrayString),
        new Column("external_data_response_order_id_yandex", ColumnType.ArrayString),
        new Column("external_data_response_order_id_delivery", ColumnType.ArrayString),
        new Column("external_data_response_order_id_external", ColumnType.ArrayString),
        new Column("external_data_response_register_id_yandex", ColumnType.ArrayString),
        new Column("external_data_response_register_id_delivery", ColumnType.ArrayString),
        new Column("external_data_response_self_export_id_yandex", ColumnType.ArrayString),
        new Column("external_data_response_self_export_id_delivery", ColumnType.ArrayString),
        new Column("external_data_response_delivery_num", ColumnType.ArrayString),

        new Column("external_data_resource_id", ColumnType.String),
        new Column("external_data_url", ColumnType.String),
        new Column("external_data_user_id", ColumnType.String),
        new Column("external_data_full", ColumnType.String)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        DeliveryApplicationLogEntry entry = new DeliveryApplicationLogEntry(line);
        Date date = dateFormat.parse(entry.getDate());

        context.write(
            date,
            //Main data
            entry.getChannels(),
            entry.getLevel(),
            entry.getText(),
            //Context
            entry.getDeliveryApplicationContext().getAttributes(),
            entry.getDeliveryApplicationContext().getDeliveryId(),
            entry.getDeliveryApplicationContext().getDeliveryUniqueName(),
            entry.getDeliveryApplicationContext().getEmail(),
            entry.getDeliveryApplicationContext().getException(),
            entry.getDeliveryApplicationContext().getGroup(),
            entry.getDeliveryApplicationContext().getLogin(),
            entry.getDeliveryApplicationContext().getMergeVars(),
            entry.getDeliveryApplicationContext().getOptions(),
            entry.getDeliveryApplicationContext().getOrderId(),
            entry.getDeliveryApplicationContext().getPickupPointCode(),
            entry.getDeliveryApplicationContext().toString(),
            //External data
            entry.getExternalData().getApplicationId(),
            entry.getExternalData().getExecutionTime(),
            entry.getExternalData().getHostname(),
            entry.getExternalData().getRequest().toString(),
            //External data request parsed data
            entry.getExternalData().getRequest().getMethodName(),
            entry.getExternalData().getRequest().getHash(),
            entry.getExternalData().getRequest().getToken(),
            entry.getExternalData().getRequest().getSenderIdYandexArray(),
            entry.getExternalData().getRequest().getWarehouseIdYandexArray(),
            entry.getExternalData().getRequest().getWarehouseIdDeliveryArray(),
            entry.getExternalData().getRequest().getShipmentIdYandexArray(),
            entry.getExternalData().getRequest().getShipmentIdDeliveryArray(),
            entry.getExternalData().getRequest().getOrderIdCleanArray(),
            entry.getExternalData().getRequest().getOrderIdYandexArray(),
            entry.getExternalData().getRequest().getOrderIdDeliveryArray(),
            entry.getExternalData().getRequest().getOrderIdExternalArray(),
            entry.getExternalData().getRequest().getIntakeIdYandexArray(),
            entry.getExternalData().getRequest().getRegisterIdYandexArray(),
            entry.getExternalData().getRequest().getSelfExportIdYandexArray(),
            entry.getExternalData().getRequest().getSelfExportIdDeliveryArray(),
            entry.getExternalData().getResponse().toString(),
            //External data response parsed data
            entry.getExternalData().getResponse().getMethodName(),
            entry.getExternalData().getResponse().getHash(),
            entry.getExternalData().getResponse().getIsError(),
            entry.getExternalData().getResponse().getIntakeIdYandexArray(),
            // TODO: 17.05.16 Add this record if table structure will be modified
            //  entry.getExternalData().getResponse().getIntakeIdDeliveryArray(),
            entry.getExternalData().getResponse().getOrderIdCleanArray(),
            entry.getExternalData().getResponse().getOrderIdYandexArray(),
            entry.getExternalData().getResponse().getOrderIdDeliveryArray(),
            entry.getExternalData().getResponse().getOrderIdExternalArray(),
            entry.getExternalData().getResponse().getRegisterIdYandexArray(),
            entry.getExternalData().getResponse().getRegisterIdDeliveryArray(),
            entry.getExternalData().getResponse().getSelfExportIdYandexArray(),
            entry.getExternalData().getResponse().getSelfExportIdDeliveryArray(),
            entry.getExternalData().getResponse().getDeliveryNumArray(),
            entry.getExternalData().getResourceId(),
            entry.getExternalData().getUrl(),
            entry.getExternalData().getUserId(),
            entry.getExternalData().toString()
        );
    }
}