package ru.yandex.market.logshatter.parser.delivery;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.delivery.component.CronTaskLogEntry;

import java.util.Date;

public class DeliveryCronTaskParser implements LogParser {
    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("id", ColumnType.String),
        new Column("start_datetime", ColumnType.DateTime),
        new Column("end_datetime", ColumnType.DateTime),
        new Column("exit_code", ColumnType.Int8),
        new Column("controller", ColumnType.String),
        new Column("action", ColumnType.String),
        new Column("options_keys", ColumnType.ArrayString),
        new Column("options", ColumnType.String),
        new Column("args", ColumnType.ArrayString),
        new Column("duration_ms", ColumnType.Int32),
        new Column("memory_peak_usage_bytes", ColumnType.UInt32),
        new Column("environment", ColumnType.String),
        new Column("hostname", ColumnType.String),
        new Column("full_hostname", ColumnType.String),
        new Column("context_keys", ColumnType.ArrayString),
        new Column("context", ColumnType.String)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        CronTaskLogEntry entry = new CronTaskLogEntry(line);
        Date date = entry.getCronTaskContext().getEndTime();

        context.write(
            date,
            entry.getCronTaskContext().getId(),
            entry.getCronTaskContext().getStartTime(),
            entry.getCronTaskContext().getEndTime(),
            entry.getCronTaskContext().getExitCode(),
            entry.getCronTaskContext().getController(),
            entry.getCronTaskContext().getAction(),
            entry.getCronTaskContext().getOptionsKeys(),
            entry.getCronTaskContext().getOptions(),
            entry.getCronTaskContext().getArgs(),
            entry.getCronTaskContext().getDuration(),
            entry.getCronTaskContext().getMemoryPeakUsage(),
            entry.getCronTaskContext().getEnvironment(),
            entry.getCronTaskContext().getHostname(),
            entry.getCronTaskContext().getFullHostname(),
            entry.getCronTaskContext().getContextKeys(),
            entry.getCronTaskContext().getContext()
        );
    }
}
