package ru.yandex.market.logshatter.parser.delivery;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 29/10/15
 */
public class DeliveryEventResourceLogParser implements LogParser {

    private static final String NONE_DATE = "0000-00-00";

    private static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("resource_id", ColumnType.Int32),
        new Column("event", ColumnType.String),
        new Column("event_code", ColumnType.String),
        new Column("billing_current_contract_date_start", ColumnType.Date)
    );

    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        int timestamp = Integer.parseInt(splits[1]);
        Integer resourceId = Integer.valueOf(splits[2]);
        String event = splits[3];
        String eventCode = splits[4];

        Date billingCurrentContractDateStart;
        if (splits.length >= 6 && !NONE_DATE.equals(splits[5])) {
            billingCurrentContractDateStart = dateFormat.parse(splits[5]);
        } else {
            billingCurrentContractDateStart = new Date(0);
        }
        context.write(timestamp, resourceId, event, eventCode, billingCurrentContractDateStart);
    }
}
