package ru.yandex.market.logshatter.parser.delivery;

import com.google.gson.JsonObject;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.delivery.component.DeliveryApplicationLogEntry;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Aleksandr Svintsov svintsov@yandex-team.ru
 *         16.05.16.
 */
public class DeliveryOpenApiLogParser implements LogParser {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("channels", ColumnType.ArrayString),
        new Column("method", ColumnType.String),
        new Column("status", ColumnType.String),
        new Column("error", ColumnType.String),
        new Column("client_id", ColumnType.String),
        new Column("sender_id", ColumnType.String),
        new Column("http_code", ColumnType.UInt16),
        new Column("memory_peak_usage", ColumnType.UInt32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        DeliveryApplicationLogEntry entry = new DeliveryApplicationLogEntry(line);
        Date date = dateFormat.parse(entry.getDate());

        String[] splits = entry.getText().split(":");
        JsonObject request = entry.getExternalData().getRequest().getJsonObject();
        JsonObject response = entry.getExternalData().getResponse().getJsonObject();

        context.write(
            date,
            entry.getChannels(),
            splits.length > 0 ? splits[0] : "",
            extractJsonElement(response, "status"),
            extractJsonElement(response, "error"),
            extractJsonElement(request, "client_id"),
            extractJsonElement(request, "sender_id"),
            entry.getExternalData().gethttpCode(),
            entry.getExternalData().getMemoryPeakUsage()
        );
    }

    private String extractJsonElement(JsonObject json, String key) {
        return (json != null && json.get(key) != null) ? json.get(key).getAsString() : "";
    }
}