package ru.yandex.market.logshatter.parser.delivery;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.delivery.component.QueueTaskLogEntry;

import java.util.Date;

public class DeliveryQueueTaskParser implements LogParser {
    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("function_name", ColumnType.String),
        new Column("command", ColumnType.String),
        new Column("status", ColumnType.String),
        new Column("set_datetime", ColumnType.DateTime),
        new Column("start_datetime", ColumnType.DateTime),
        new Column("end_datetime", ColumnType.DateTime),
        new Column("memory_peak_usage_bytes", ColumnType.UInt32),
        new Column("workers_count", ColumnType.Int16),
        new Column("duration_ms", ColumnType.Int32)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        QueueTaskLogEntry entry = new QueueTaskLogEntry(line);
        Date date = entry.getQueueTaskContext().getEndTime();

        context.write(
            date,
            //Context
            entry.getQueueTaskContext().getFunction(),
            entry.getQueueTaskContext().getCommand(),
            entry.getQueueTaskContext().getStatus(),
            entry.getQueueTaskContext().getSetTime(),
            entry.getQueueTaskContext().getStartTime(),
            date,
            entry.getQueueTaskContext().getMemoryPeakUsage(),
            entry.getQueueTaskContext().getWorkersCount(),
            entry.getQueueTaskContext().getDuration()
        );
    }
}
