package ru.yandex.market.logshatter.parser.delivery.blue.market;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.Date;

public class CheckpointStatusMonitoringRecord {

    private Date tranDate;
    private String host;
    private Integer status;
    private Integer previousStatus;
    private Long durationMillis;
    private Long orderId;
    private Long trackId;
    private Integer deliveryServiceId;
    private String color;

    public Date getTranDate() {
        return tranDate;
    }

    public void setTranDate(Date tranDate) {
        this.tranDate = tranDate;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getPreviousStatus() {
        return previousStatus;
    }

    public void setPreviousStatus(Integer previousStatus) {
        this.previousStatus = previousStatus;
    }

    public Long getDurationMillis() {
        return durationMillis;
    }

    public void setDurationMillis(Long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getTrackId() {
        return trackId;
    }

    public void setTrackId(Long trackId) {
        this.trackId = trackId;
    }

    public Integer getDeliveryServiceId() {
        return deliveryServiceId;
    }

    public void setDeliveryServiceId(Integer deliveryServiceId) {
        this.deliveryServiceId = deliveryServiceId;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        CheckpointStatusMonitoringRecord that = (CheckpointStatusMonitoringRecord) o;

        return new EqualsBuilder()
            .append(tranDate, that.tranDate)
            .append(host, that.host)
            .append(status, that.status)
            .append(previousStatus, that.previousStatus)
            .append(durationMillis, that.durationMillis)
            .append(orderId, that.orderId)
            .append(trackId, that.trackId)
            .append(deliveryServiceId, that.deliveryServiceId)
            .append(color, that.color)
            .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
            .append(tranDate)
            .append(host)
            .append(status)
            .append(previousStatus)
            .append(durationMillis)
            .append(orderId)
            .append(trackId)
            .append(deliveryServiceId)
            .append(color)
            .toHashCode();
    }

    @Override
    public String toString() {
        return "CheckpointStatusMonitoringRecord{" +
            "tranDate=" + tranDate +
            ", host='" + host + '\'' +
            ", status=" + status +
            ", previousStatus=" + previousStatus +
            ", durationMillis=" + durationMillis +
            ", orderId=" + orderId +
            ", trackId=" + trackId +
            ", deliveryServiceId=" + deliveryServiceId +
            ", color='" + color + '\'' +
            '}';
    }
}
