package ru.yandex.market.logshatter.parser.delivery.blue.market;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.Date;

public class OrderStatusMonitoringRecord {

    private Date tranDate;
    private String host;
    private Long orderId;
    private Long shipmentId;
    private Integer deliveryServiceId;
    private DeliveryOrderStatusEventType eventType;
    private String color;

    public Date getTranDate() {
        return tranDate;
    }

    public void setTranDate(Date tranDate) {
        this.tranDate = tranDate;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getShipmentId() {
        return shipmentId;
    }

    public void setShipmentId(Long shipmentId) {
        this.shipmentId = shipmentId;
    }

    public Integer getDeliveryServiceId() {
        return deliveryServiceId;
    }

    public void setDeliveryServiceId(Integer deliveryServiceId) {
        this.deliveryServiceId = deliveryServiceId;
    }

    public DeliveryOrderStatusEventType getEventType() {
        return eventType;
    }

    public void setEventType(DeliveryOrderStatusEventType eventType) {
        this.eventType = eventType;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        OrderStatusMonitoringRecord that = (OrderStatusMonitoringRecord) o;

        return new EqualsBuilder()
            .append(tranDate, that.tranDate)
            .append(host, that.host)
            .append(orderId, that.orderId)
            .append(shipmentId, that.shipmentId)
            .append(deliveryServiceId, that.deliveryServiceId)
            .append(eventType, that.eventType)
            .append(color, that.color)
            .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
            .append(tranDate)
            .append(host)
            .append(orderId)
            .append(shipmentId)
            .append(deliveryServiceId)
            .append(eventType)
            .append(color)
            .toHashCode();
    }

    @Override
    public String toString() {
        return "OrderStatusMonitoringRecord{" +
            "tranDate=" + tranDate +
            ", host='" + host + '\'' +
            ", orderId=" + orderId +
            ", shipmentId=" + shipmentId +
            ", deliveryServiceId=" + deliveryServiceId +
            ", eventType=" + eventType +
            ", color='" + color + '\'' +
            '}';
    }
}
