package ru.yandex.market.logshatter.parser.delivery.component;

import ru.yandex.market.logshatter.parser.delivery.component.jsondata.CronTaskLogContext;

public class CronTaskLogEntry extends LogEntry {
    public CronTaskLogEntry(String recordText) throws Exception {
        super(recordText);
    }

    private static final String LOG_DELIMIT_REGEX = "^\\[(\\S+ \\S+)] ([^:]+):([^:]+)[: ]*([\\s|\\S]+) (\\{[\\s|\\S]+\\}) (\\[\\]|\\{[\\s|\\S]+\\})$";

    @Override
    public String getPatternString() {
        return LOG_DELIMIT_REGEX;
    }

    @Override
    public void setContext(String context) throws Exception {
        this.context = new CronTaskLogContext(context);
    }

    public CronTaskLogContext getCronTaskContext() {
        return (CronTaskLogContext) getContext();
    }
}
