package ru.yandex.market.logshatter.parser.delivery.component;

import ru.yandex.market.logshatter.parser.delivery.component.jsondata.DeliveryApplicationLogContext;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         02.03.16.
 */
public class DeliveryApplicationLogEntry extends LogEntry {

    private static final String LOG_DELIMIT_REGEX = "^\\[(\\S+ \\S+)] ([^:]+):([^:]+)[: ]*([\\s|\\S]+) (\\[\\]|\\{[\\s|\\S]+\\}) (\\{[\\s|\\S]+\\})$";

    public DeliveryApplicationLogEntry(String recordText) throws Exception {
        super(recordText);
    }

    @Override
    public String getPatternString() {
        return LOG_DELIMIT_REGEX;
    }

    @Override
    public void setContext(String context) throws Exception {
        this.context = new DeliveryApplicationLogContext(context);
    }

    public DeliveryApplicationLogContext getDeliveryApplicationContext() {
        return (DeliveryApplicationLogContext) getContext();
    }
}