package ru.yandex.market.logshatter.parser.delivery.component;

import ru.yandex.market.logshatter.parser.delivery.component.jsondata.DeliveryApplicationLogExternalData;
import ru.yandex.market.logshatter.parser.delivery.component.jsondata.DeliveryApplicationLogJsonData;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract public class LogEntry {

    private static final int KEY_DATE = 1;
    private static final int KEY_CHANNEL = 2;
    private static final int KEY_LEVEL = 3;
    private static final int KEY_TEXT = 4;
    private static final int KEY_CONTEXT = 5;
    private static final int KEY_EXTERNAL_DATA = 6;

    protected String date;

    private String[] channels;

    protected DeliveryApplicationLogJsonData context;

    private DeliveryApplicationLogExternalData externalData;

    private String level;

    protected String text;

    public LogEntry(String recordText) throws Exception {
        Matcher matcher = getPattern().matcher(recordText);

        if (matcher.find()) {
            initMatchedData(matcher);
        }
    }

    abstract public String getPatternString();

    public Pattern getPattern() {
        return Pattern.compile(getPatternString());
    }

    private void initMatchedData(Matcher matcher) throws Exception {
        setDate(matcher.group(KEY_DATE));
        setChannels(matcher.group(KEY_CHANNEL));
        setLevel(matcher.group(KEY_LEVEL));
        setText(matcher.group(KEY_TEXT));
        setContext(matcher.group(KEY_CONTEXT));
        setExternalData(matcher.group(KEY_EXTERNAL_DATA));
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String[] getChannels() {
        return channels;
    }

    public void setChannels(String channels) {
        this.channels = channels.split(Pattern.quote("."));
    }

    public DeliveryApplicationLogJsonData getContext() {
        return context;
    }

    abstract public void setContext(String context) throws Exception;

    public DeliveryApplicationLogExternalData getExternalData() {
        return externalData;
    }

    public void setExternalData(String externalData) throws Exception {
        this.externalData = new DeliveryApplicationLogExternalData(externalData);
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }
}
